/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.web.dto.UserDeviceGroupBind;
import ru.linologi.auth.dto.User;

@Component
public class UserDeviceGroupDao {
    private final JdbcTemplate jdbcTemplate;

    public UserDeviceGroupDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void createBinding(UserDeviceGroupBind udg) {
        this.jdbcTemplate.update("insert into user_device_group (user_id,device_group_id) values (?,?) ", new Object[]{udg.getUserId(), udg.getDeviceGroupId()});
    }

    public void unbind(UserDeviceGroupBind userDeviceGroupBind) {
        this.jdbcTemplate.update("delete from user_device_group where user_id=? and device_group_id=?", new Object[]{userDeviceGroupBind.getUserId(), userDeviceGroupBind.getDeviceGroupId()});
    }

    public List<User> getUsersInDeviceGroup(long id) {
        return this.jdbcTemplate.query("select usr.id as id,first_name as fn,last_name as ln,  active,username from user_device_group as udg inner join usr on usr.id=udg.user_id where udg.device_group_id = ?", (rs, rowNum) -> {
            User user = new User();
            user.setId(Long.valueOf(rs.getLong("id")));
            user.setFirstName(rs.getString("fn"));
            user.setLastName(rs.getString("ln"));
            user.setActive(rs.getBoolean("active"));
            user.setUsername(rs.getString("username"));
            return user;
        }, new Object[]{id});
    }
}

