/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.TonerColor;
import ru.interunity.ep.dto.ColorSuppliesDto;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.dto.LineChanget;
import ru.interunity.ep.dto.RepForSuppUnitItem;
import ru.interunity.ep.dto.SuppliesGetSupDto;
import ru.interunity.ep.dto.SuppliesUnit;

@Component
public class SuppliesDao {
    private final JdbcTemplate jdbcTemplate;

    public SuppliesDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<RepForSuppUnitItem> getSupReportsInDev(Device device, LocalDateTime dateStart) {
        List listSupInDev = this.getSupInDev(device.getId());
        ArrayList<RepForSuppUnitItem> items = new ArrayList<RepForSuppUnitItem>();
        for (SuppliesUnit suppliesUnit : listSupInDev) {
            items.add(this.getRepForSuppUnit(device, suppliesUnit, dateStart));
        }
        return items;
    }

    private RepForSuppUnitItem getRepForSuppUnit(Device device, SuppliesUnit supInDevDto, LocalDateTime dateStart) {
        Map supTypeRef = this.getCodeDescr("PrtMarkerSuppliesType");
        RepForSuppUnitItem item = new RepForSuppUnitItem();
        item.setDevice(device);
        ArrayList lines = new ArrayList();
        AtomicReference<Double> prev = new AtomicReference<Double>(0.0);
        AtomicReference<Double> all = new AtomicReference<Double>(0.0);
        AtomicReference<String> oldSn = new AtomicReference<String>("");
        this.jdbcTemplate.query("SELECT  val, timeInsert, snSupp FROM suppliesLog where timeInsert >= ? AND devID= ? and type= ? and color= ? order by id  ", rs -> {
            if (rs.next()) {
                prev.set(Double.parseDouble(rs.getString("val").replace(",", ".")));
                oldSn.set(rs.getString("snSupp"));
            }
            String dateFirstData = "";
            boolean dateSet = false;
            while (rs.next()) {
                double raz;
                String valString;
                LineChanget lineChanget = new LineChanget();
                lineChanget.setPrevSupVal(((Double)prev.get()).doubleValue());
                if (!dateSet) {
                    dateFirstData = rs.getString("timeInsert");
                    dateSet = true;
                }
                if ((valString = rs.getString("val")).contains(",")) {
                    valString = valString.replace(",", ".");
                }
                double val = Double.parseDouble(valString);
                lineChanget.setActualSupVal(val);
                if ((Double)prev.get() >= val) {
                    raz = (Double)prev.get() - val;
                } else {
                    lineChanget.setTimeSupChange(rs.getString("timeInsert"));
                    lineChanget.setOldSn((String)oldSn.get());
                    if (!((String)oldSn.get()).isEmpty() || !rs.getString("snSupp").equals("")) {
                        lineChanget.setNewSn(rs.getString("snSupp"));
                    }
                    raz = 0.0;
                    lines.add(lineChanget);
                }
                all.set((Double)all.get() + raz);
                prev.set(val);
                oldSn.set(rs.getString("snSupp"));
            }
            if ((Double)all.get() != 0.0) {
                item.setSupType((String)supTypeRef.get(supInDevDto.getType()));
                item.setTypeColor(supInDevDto.getColor());
                item.setUsing((Double)all.get() / 100.0);
                item.setFromDate(dateFirstData);
            }
            return null;
        }, new Object[]{dateStart, device.getId(), supInDevDto.getType(), supInDevDto.getColor()});
        item.setLineChangets(lines);
        return item;
    }

    public Map<String, String> getCodeDescr(String nameGroup) {
        HashMap<String, String> listDescr = new HashMap<String, String>();
        this.jdbcTemplate.query("SELECT * FROM codDesc WHERE \"group\" = ?", rs -> {
            while (rs.next()) {
                listDescr.put(rs.getString("idInGroup"), rs.getString("description"));
            }
            return null;
        }, new Object[]{nameGroup});
        return listDescr;
    }

    public Map<Long, List<RepForSuppUnitItem>> getSupReportsAllDev(List<Device> devices, LocalDateTime dateStart) {
        HashMap<Long, List<RepForSuppUnitItem>> report = new HashMap<Long, List<RepForSuppUnitItem>>();
        devices.forEach(device -> report.put(device.getId(), this.getSupReportsInDev(device, dateStart)));
        return report;
    }

    private List<SuppliesUnit> getSupInDev(long idDev) {
        ArrayList<SuppliesUnit> listSupInDev = new ArrayList<SuppliesUnit>();
        this.jdbcTemplate.query("SELECT type , color FROM  suppliesLog WHERE devID= ? GROUP BY  suppliesLog.type ,  suppliesLog.color", rs -> {
            while (rs.next()) {
                SuppliesUnit dto = SuppliesUnit.builder().color(rs.getString("color")).type(rs.getString("type")).build();
                listSupInDev.add(dto);
            }
            return null;
        }, new Object[]{idDev});
        return listSupInDev;
    }

    public List<SuppliesGetSupDto> getSup(int idDev, int type, String color, LocalDateTime dateStart, LocalDateTime dateEnd) {
        ArrayList<SuppliesGetSupDto> sup = new ArrayList<SuppliesGetSupDto>();
        this.jdbcTemplate.query("SELECT timeInsert, val FROM supplieslog WHERE devId= ? and color= ? and type= ? and  CAST(REPLACE(val, ',', '.') AS DOUBLE PRECISION) >=0 and timeInsert>= ? and timeInsert<= ? ORDER BY timeInsert", rs -> sup.add(SuppliesGetSupDto.builder().timeInsert(rs.getTimestamp("timeInsert").toString()).val(Float.valueOf(rs.getString("val").replace(",", ".")).floatValue()).build()), new Object[]{idDev, color, String.valueOf(type), dateStart, dateEnd});
        return sup;
    }

    public List<ColorSuppliesDto> getAllColorSuppliesLevel() {
        ArrayList<ColorSuppliesDto> colors = new ArrayList<ColorSuppliesDto>();
        this.jdbcTemplate.query("SELECT supplieslog.id, supplieslog.type, supplieslog.color, supplieslog.val, supplieslog.description, zap1.devId FROM supplieslog RIGHT JOIN (SELECT max(supplieslog.id) as id, devId FROM supplieslog WHERE CAST(supplieslog.type AS INTEGER) IN (3, 6, 5, 21) GROUP BY supplieslog.type, supplieslog.color, devId) as zap1 ON supplieslog.id = zap1.id", rs -> {
            while (rs.next()) {
                colors.add(ColorSuppliesDto.builder().id(rs.getLong("id")).type(Integer.parseInt(rs.getString("type"))).color(TonerColor.findColor((String)rs.getString("color").trim(), (String)rs.getString("description").trim())).val(Float.parseFloat(rs.getString("val").replace(',', '.'))).devId(rs.getInt("devId")).build());
            }
        });
        return colors;
    }

    public List<SuppliesUnit> getSupUnit(int idDev) {
        ArrayList<SuppliesUnit> units = new ArrayList<SuppliesUnit>();
        this.jdbcTemplate.query("SELECT supplieslog.type as type, supplieslog.color as color, supplies_type.nameRus as nameRus FROM supplieslog LEFT JOIN supplies_type ON CAST(supplieslog.type AS INTEGER) = supplies_type.id WHERE devId = ? AND CAST(suppliesLog.type AS INTEGER) not in (4, 10, 1) GROUP BY \"type\", color, supplies_type.namerus", rs -> {
            while (rs.next()) {
                units.add(SuppliesUnit.builder().color(rs.getString("color")).type(rs.getString("type")).nameRus(rs.getString("nameRus")).build());
            }
            return null;
        }, new Object[]{idDev});
        return units;
    }
}

