/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.StockDto;
import ru.interunity.ep.web.dto.ChangeType;

@Component
public class StockLogDao {
    private final JdbcTemplate template;

    public StockLogDao(JdbcTemplate template) {
        this.template = template;
    }

    public List<StockDto> getLogByDate(LocalDateTime start, LocalDateTime end) {
        return (List)this.template.query("SELECT * FROM stock_log WHERE request_date > ? AND request_date < ?", rs -> {
            ArrayList<StockDto> stocks = new ArrayList<StockDto>();
            while (rs.next()) {
                stocks.add(StockDto.builder().id((long)rs.getInt("id")).itemId((long)rs.getInt("item_id")).modifyDate(rs.getTimestamp("request_date").toLocalDateTime()).requestDescription(rs.getString("request_description")).writeOffDevice(Long.valueOf(rs.getLong("write_off_device"))).build());
            }
            return stocks;
        }, new Object[]{start, end});
    }

    public void addNewLogItem(StockDto stock, ChangeType changeType) {
        this.template.update("INSERT INTO stock_log(item_id, request_date, request_description, write_off_device, change_type) VALUES (?, ?, ?, ?, ?)", new Object[]{stock.getItemId(), stock.getModifyDate(), stock.getRequestDescription(), stock.getWriteOffDevice(), changeType.name()});
    }

    public void updateLogItem(StockDto stock) {
        this.template.update("UPDATE stock_log SET item_id = ?, request_date = ?, request_description = ?, write_off_device = ? WHERE id = ?", new Object[]{stock.getItemId(), stock.getModifyDate(), stock.getRequestDescription(), stock.getWriteOffDevice(), stock.getId()});
    }
}

