/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.DeviceGroup;
import ru.interunity.ep.dto.EpNetwork;

@Component
public class IPSDao {
    private final JdbcTemplate jdbcTemplate;

    public IPSDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public EpNetwork getIPSbyId(int id) {
        EpNetwork network = EpNetwork.builder().build();
        this.jdbcTemplate.query("SELECT * FROM ips JOIN am.device_groups dg on ips.default_group = dg.id WHERE ips.id = ?", rs -> {
            if (rs.next()) {
                network.setNetId(Long.valueOf(rs.getInt("ips.id")));
                network.setName(rs.getString("ips.name"));
                network.setNetStartString(rs.getString("ips.ip_from"));
                network.setNetEndString(rs.getString("ips.ip_to"));
                network.setIsActive(Boolean.valueOf(rs.getBoolean("ips.is_active")));
                network.setDefaultGroup(DeviceGroup.builder().id(Integer.valueOf(rs.getInt("gd.id"))).name(rs.getString("gd.name")).description(rs.getString("gd.description")).active(rs.getBoolean("gd.is_active")).build());
            }
            return null;
        }, new Object[]{id});
        return network;
    }

    public List<EpNetwork> getAllIPS() {
        ArrayList<EpNetwork> networks = new ArrayList<EpNetwork>();
        this.jdbcTemplate.query("SELECT ips.id ips_id, ips.name ips_name, ips.ip_from ips_from, ips.ip_to ips_to, ips.is_active ips_is_active, dg.id dg_id, dg.name dg_name , dg.description dg_description, dg.is_active dg_is_active FROM ips JOIN device_groups dg on ips.default_group = dg.id", rs -> {
            while (rs.next()) {
                networks.add(EpNetwork.builder().netId(Long.valueOf(rs.getLong("ips_id"))).name(rs.getString("ips_name")).netStartString(rs.getString("ips_from")).netEndString(rs.getString("ips_to")).isActive(Boolean.valueOf(rs.getBoolean("ips_is_active"))).defaultGroup(DeviceGroup.builder().id(Integer.valueOf(rs.getInt("dg_id"))).name(rs.getString("dg_name")).description(rs.getString("dg_description")).active(rs.getBoolean("dg_is_active")).build()).build());
            }
            return null;
        });
        return networks;
    }

    public void addIps(EpNetwork network) {
        this.jdbcTemplate.update("INSERT INTO ips(ip_from, ip_to,name, default_group) VALUES (?,?,?,?)", new Object[]{network.getNetStartString(), network.getNetEndString(), network.getName(), network.getDefaultGroup().getId()});
    }

    public void updateIps(EpNetwork network) {
        this.jdbcTemplate.update("UPDATE ips SET ip_from = ?, ip_to = ?, name = ?, is_active = ?, default_group=? WHERE id = ?", new Object[]{network.getNetStartString(), network.getNetEndString(), network.getName(), network.getIsActive(), network.getDefaultGroup().getId(), network.getNetId()});
    }

    public void deleteIps(int id) {
        this.jdbcTemplate.update("DELETE FROM ips WHERE id = ?", new Object[]{id});
    }
}

