/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.dao;

import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dto.DeviceGroup;

@Component
public class DeviceGroupDao {
    private final JdbcTemplate jdbcTemplate;

    public void writeDeviceGroup(DeviceGroup deviceGroup) {
        this.jdbcTemplate.update("insert into device_groups (name, description) VALUES (?, ?)", new Object[]{deviceGroup.getName(), deviceGroup.getDescription()});
    }

    public List<DeviceGroup> findAll() {
        return this.jdbcTemplate.query("select * from device_groups", (rs, rowNum) -> DeviceGroup.builder().id(Integer.valueOf(rs.getInt("id"))).name(rs.getString("name")).active(rs.getBoolean("is_active")).description(rs.getString("description")).build());
    }

    public void bindDeviceToGroup(long deviceId, long groupId) {
        this.jdbcTemplate.update("insert into device_group_link (printer_id, group_id) values (?, ?)", new Object[]{deviceId, groupId});
    }

    public void unbindDeviceToGroup(long deviceId, long groupId) {
        this.jdbcTemplate.update("delete from device_group_link where printer_id = ? and group_id = ?", new Object[]{deviceId, groupId});
    }

    public List<DeviceGroup> getDeviceGroups(long deviceId) {
        return this.jdbcTemplate.query("select * from device_groups where id in (select group_id from device_group_link where printer_id = ?)", (rs, rowNum) -> DeviceGroup.builder().id(Integer.valueOf(rs.getInt("id"))).name(rs.getString("name")).active(rs.getBoolean("is_active")).description(rs.getString("description")).build(), new Object[]{deviceId});
    }

    public List<Integer> getDeviceGroupIds(long deviceId) {
        return this.jdbcTemplate.queryForList("select device_groups.id from device_groups where id in (select group_id from device_group_link where printer_id = ?)", Integer.class, new Object[]{deviceId});
    }

    public DeviceGroupDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

