/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.web.dto.UserGroupDto;
import ru.interunity.ep.web.service.UserGroupService;
import ru.linologi.auth.dto.User;

@RestController
@RequestMapping(value={"/api/v2/group"})
public class UserGroupController {
    public final UserGroupService userGroupService;

    public UserGroupController(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<UserGroupDto> addNewGroup(@RequestBody UserGroupDto ugd) {
        return this.userGroupService.addNewGroup(ugd);
    }

    @GetMapping(value={"/get-all-group"})
    public ResponseEntity<List<UserGroupDto>> getAllGroups() {
        return this.userGroupService.getAllGroups();
    }

    @GetMapping(value={"/get-group/{id}"})
    public ResponseEntity<UserGroupDto> getGroupById(@PathVariable Integer id) {
        return this.userGroupService.getGroupById(id);
    }

    @PostMapping(value={"/update-group"})
    public ResponseEntity<String> updateGroup(@RequestBody UserGroupDto ugd) {
        return this.userGroupService.updateGroup(ugd);
    }

    @PostMapping(value={"/delete-group/{id}"})
    public ResponseEntity<String> deleteGroupById(@PathVariable Integer id) {
        return this.userGroupService.deleteGroupById(id);
    }

    @PostMapping(value={"/add-relation"})
    public ResponseEntity<String> addUserGroupRelation(@RequestParam Integer userId, @RequestParam Integer groupId) {
        return this.userGroupService.addUserGroupRelation(userId, groupId);
    }

    @PostMapping(value={"/delete-relation"})
    public ResponseEntity<String> deleteUserGroupRelation(Integer userId, Integer groupId) {
        return this.userGroupService.deleteUserGroupRelation(userId, groupId);
    }

    @GetMapping(value={"/get-user-relation"})
    public ResponseEntity<List<UserGroupDto>> getUserGroupsById(@RequestParam Integer userId) {
        return this.userGroupService.getUserGroupsById(userId);
    }

    @GetMapping(value={"/get-group-relation"})
    public ResponseEntity<List<User>> getGroupUsersById(@RequestParam Integer groupId) {
        return this.userGroupService.getGroupUsersById(groupId);
    }

    @GetMapping(value={"/get-group-with-users"})
    public ResponseEntity<List<UserGroupDto>> getAllGroupsWithUsers() {
        return this.userGroupService.getAllGroupsWithUsers();
    }

    @GetMapping(value={"/get-users-with-groups"})
    public ResponseEntity<Map<Long, List<UserGroupDto>>> getAllUsersWithGroup() {
        return this.userGroupService.getAllUsersWithGroup();
    }
}

