/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.time.LocalDateTime;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.SuppliesDTO;
import ru.interunity.ep.web.dao.SuppliesChangesLogDao;

@RestController
@RequestMapping(value={"/api/v2/change_log"})
public class SuppliesChangesLogController {
    private final SuppliesChangesLogDao suppliesChangesLogDao;

    public SuppliesChangesLogController(SuppliesChangesLogDao suppliesChangesLogDao) {
        this.suppliesChangesLogDao = suppliesChangesLogDao;
    }

    @GetMapping(value={"/get"})
    public List<SuppliesDTO> getStockLogByDate(@RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startTime, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endTime) {
        return this.suppliesChangesLogDao.getChangeLogByDate(startTime, endTime);
    }

    @GetMapping(value={"/get/{id}"})
    public List<SuppliesDTO> getStockLogByDateAndId(@PathVariable Integer id) {
        return this.suppliesChangesLogDao.getChangeLogByDateAndId(id);
    }

    @PostMapping(value={"/add"})
    public void AddStock(@RequestBody SuppliesDTO supLogItem) {
        this.suppliesChangesLogDao.addNewChangeLogItem(supLogItem);
    }

    @DeleteMapping(value={"/delete"})
    public void updateStock(@RequestParam Integer id) {
        this.suppliesChangesLogDao.deleteById(id);
    }
}

