/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.time.LocalDateTime;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.StockDto;
import ru.interunity.ep.web.dao.StockLogDao;
import ru.interunity.ep.web.dto.ChangeType;

@RestController
@RequestMapping(value={"/api/v2/stock_log"})
public class StockLogController {
    private final StockLogDao stockLogDao;

    public StockLogController(StockLogDao stockLogDao) {
        this.stockLogDao = stockLogDao;
    }

    @GetMapping(value={"/get"})
    public List<StockDto> getStockLogByDate(@RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime start, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime end) {
        return this.stockLogDao.getLogByDate(start, end);
    }

    @PostMapping(value={"/add"})
    public void AddStock(@RequestBody StockDto logItem) {
        this.stockLogDao.addNewLogItem(logItem, ChangeType.MANUAL);
    }

    @PatchMapping(value={"/update"})
    public void updateStock(@RequestBody StockDto logItem) {
        this.stockLogDao.updateLogItem(logItem);
    }
}

