/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.dao.QueueDao;
import ru.interunity.ep.dto.SavedQueue;

@RestController
@RequestMapping(value={"/api/v2/queues"})
public class QueueController {
    private final QueueDao queueDao;
    private final PrinterDao printerDao;

    @GetMapping(value={"/get-queues"})
    public List<SavedQueue> getAllQueue() {
        List queues = this.queueDao.getAllQueue();
        queues.forEach(queue -> {
            if (queue.getPrinter() != null) {
                queue.setDevice(this.printerDao.getDevice(queue.getPrinter()));
            }
        });
        return queues;
    }

    @PostMapping(value={"/create-queues"})
    public ResponseEntity<JSONObject> createQueue(@RequestBody SavedQueue queue) {
        int result = this.queueDao.saveQueue(queue);
        if (result > 0) {
            JSONObject body = new JSONObject();
            body.put("result", (Object)"Queue created");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)body);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<JSONObject> deleteQueu(@RequestParam(value="id") Integer idQueue) {
        int result = this.queueDao.deleteQueue(idQueue);
        if (result > 0) {
            JSONObject body = new JSONObject();
            body.put("result", (Object)"Queue deleted");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)body);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
    }

    public QueueController(QueueDao queueDao, PrinterDao printerDao) {
        this.queueDao = queueDao;
        this.printerDao = printerDao;
    }
}

