/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.io.IOException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.allscan.AllScanWorker;
import ru.interunity.ep.allscan.DeterminType;
import ru.interunity.ep.dto.CheckRq;
import ru.interunity.ep.dto.CheckRs;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.dto.printer.SnmpCredentialDto;
import ru.interunity.ep.snmp.mib.MIBParser;
import ru.interunity.ep.snmp.srv.OneTimePrinterCheck;
import ru.reasy.snmp.mibs.MibException;

@RestController
@RequestMapping(value={"/api/printer/manual/"})
public class ManualPrinterAdd {
    private final AllScanWorker scanWorker;
    private final MIBParser mibParser;

    @PostMapping(value={"check"})
    public CheckRs check(@RequestBody CheckRq checkRq) throws MibException, IOException {
        DeterminType dt = new DeterminType();
        boolean p9100 = dt.scanPort(checkRq.getIp(), 9100, 500);
        boolean p631 = dt.scanPort(checkRq.getIp(), 631, 500);
        boolean p515 = dt.scanPort(checkRq.getIp(), 515, 500);
        Device device = new Device();
        if (p515 || p631 || p9100) {
            device.setP515(p515);
            device.setP631(p631);
            device.setP9100(p9100);
            device.setIp(checkRq.getIp());
            try {
                SnmpCredentialDto credential = SnmpCredentialDto.builder().port(checkRq.getPort() != 0 ? checkRq.getPort() : 161).community(checkRq.getCommunity()).version(checkRq.getSnmpVersion()).v3Username(checkRq.getLogin()).v3Password(checkRq.getPassword()).v3PasswordHash(checkRq.getAuthEncryptProtocol()).v3EncryptPassword(checkRq.getExchangePassword()).v3EncryptPasswordHash(checkRq.getExchangeEncryptionProtocol()).build();
                OneTimePrinterCheck instance = OneTimePrinterCheck.instance((Device)device, (SnmpCredentialDto)credential, (MIBParser)this.mibParser);
                instance.getDeviceInfo();
                return CheckRs.builder().success(true).device(device).build();
            }
            catch (Exception e) {
                return CheckRs.builder().success(false).message("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 " + e.getMessage()).build();
            }
        }
        return CheckRs.builder().success(false).message("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e").build();
    }

    public ManualPrinterAdd(AllScanWorker scanWorker, MIBParser mibParser) {
        this.scanWorker = scanWorker;
        this.mibParser = mibParser;
    }
}

