/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.web.srv.DevInfoGet;
import ru.interunity.ep.web.srv.JdbcSqlInit;
import ru.reasy.snmp.mibs.MibException;

@RestController
public class MainController {
    private static final Logger log = LoggerFactory.getLogger(MainController.class);
    private final JdbcSqlInit jdbcSqlInit;

    public MainController(JdbcSqlInit jdbcSqlInit) {
        this.jdbcSqlInit = jdbcSqlInit;
    }

    @Deprecated
    @RequestMapping(value={"/DC"})
    public String getDevices() {
        return this.jdbcSqlInit.getDevListArr().toString();
    }

    @Deprecated
    @RequestMapping(value={"/DCH"})
    public String getDevicesHtml() {
        return this.jdbcSqlInit.getDevListHtml();
    }

    @Deprecated
    @RequestMapping(value={"/GFR"})
    public String getFullReport(@RequestParam(required=false) String dateBegine, @RequestParam(required=false) String dateEnd) {
        return this.jdbcSqlInit.getCounterReport(dateBegine, dateEnd);
    }

    @Deprecated
    @RequestMapping(value={"/CR"})
    public String getCounterReport(@RequestParam(required=false) Integer devId) {
        StringBuilder sb = new StringBuilder();
        if (devId != null) {
            sb.append(this.jdbcSqlInit.getSupReportsInDev(devId.intValue()));
        } else {
            sb.append(this.jdbcSqlInit.getSupReportsAllDev());
        }
        return sb.toString();
    }

    @Deprecated
    @RequestMapping(value={"/GS"})
    public String getDevicesSupplies(@RequestParam(required=false) Integer idDev, @RequestParam(required=false) Integer type, @RequestParam(required=false) String color, @RequestParam(required=false) String dateBegine, @RequestParam(required=false) String dateEnd) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)dateBegine) && !StringUtils.isEmpty((CharSequence)dateEnd)) {
            log.info("Date begin and end set");
            sb.append(this.jdbcSqlInit.getSup(idDev.intValue(), type.intValue(), color, dateBegine, dateEnd));
        } else {
            sb.append(this.jdbcSqlInit.getSup(idDev.intValue(), type.intValue(), color));
        }
        return sb.toString();
    }

    @Deprecated
    @RequestMapping(value={"/GASU"})
    public String getDevices(@RequestParam(required=false) Integer idDev) {
        return this.jdbcSqlInit.getSupUnit(idDev.intValue()).toString();
    }

    @Deprecated
    @RequestMapping(value={"/GA"})
    public String getDevicesAlert(@RequestParam(required=false) String devId, @RequestParam(required=false) String dateBegine, @RequestParam(required=false) String dateEnd) {
        if (StringUtils.isEmpty((CharSequence)dateBegine)) {
            dateBegine = LocalDateTime.now().minusDays(7L).toString();
        }
        return this.jdbcSqlInit.getAlert(devId, dateBegine, dateEnd).toString();
    }

    @RequestMapping(value={"/SR"})
    public String getSuppliesReport(@RequestParam(required=false) Integer devId) {
        StringBuilder sb = new StringBuilder();
        if (devId != null) {
            String report = this.jdbcSqlInit.getSupReportsInDev(devId.intValue());
            sb.append("<div class='supRep'><table border='0'>");
            sb.append("<thead><font size='+1'><b>\u0417\u0430\u043c\u0435\u043d\u044b</b></font></thead>");
            sb.append(report);
            sb.append("<table></div>");
        } else {
            sb.append(this.jdbcSqlInit.getSupReportsAllDev());
        }
        return sb.toString();
    }

    @RequestMapping(value={"/DI"})
    public String getDevicesInfo(@RequestParam(required=false) String idDev) throws MibException, SQLException, IOException, ClassNotFoundException {
        DevInfoGet dig = new DevInfoGet(idDev, this.jdbcSqlInit);
        StringBuilder stringBuilder = new StringBuilder();
        if (dig.checkDev()) {
            stringBuilder.append("<font size='+1'><b>");
            stringBuilder.append(dig.mainInfo());
            stringBuilder.append("</b></font>");
            stringBuilder.append("<table border='0' width='100%'>");
            stringBuilder.append("<tr><td valign='top'>");
            stringBuilder.append(dig.getAllSupplies());
            stringBuilder.append("</td><td valign='top'>");
            stringBuilder.append(dig.getAllStates());
            stringBuilder.append("</td></tr>");
            stringBuilder.append("<tr><td colspan='2'>");
            stringBuilder.append(dig.getAllAlerts());
            stringBuilder.append("</td></tr>");
            stringBuilder.append("</table>");
        } else {
            stringBuilder.append("Offline");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    @RequestMapping(value={"/CL"})
    public String getCounterLog(@RequestParam(required=false) Integer idDev, @RequestParam(required=false) String dateBegine, @RequestParam(required=false) String dateEnd) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)dateBegine) && !StringUtils.isEmpty((CharSequence)dateEnd)) {
            sb.append(this.jdbcSqlInit.getCounterLog(idDev.intValue(), dateBegine, dateEnd));
            log.info("Date begin and end set");
        }
        if (dateBegine != null && StringUtils.isEmpty((CharSequence)dateEnd)) {
            log.info("Date begin set");
            sb.append(this.jdbcSqlInit.getCounterLog(idDev.intValue(), dateBegine, 1));
        }
        if (dateEnd != null && StringUtils.isEmpty((CharSequence)dateBegine)) {
            log.info("Date end set");
            sb.append(this.jdbcSqlInit.getCounterLog(idDev.intValue(), dateEnd, 2));
        }
        if (dateBegine == null && dateEnd == null) {
            log.info("Date  unset");
            sb.append(this.jdbcSqlInit.getCounterLog(idDev.intValue()));
        }
        return sb.toString();
    }
}

