/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.service.CommonEmailServiceImpl;

@RestController
@RequestMapping(value={"/api/v2/email"})
public class MailController {
    private final CommonEmailServiceImpl emailService;

    public MailController(CommonEmailServiceImpl emailService) {
        this.emailService = emailService;
    }

    @GetMapping(value={"/send"})
    @ResponseBody
    public ResponseEntity sendSimplEmail(@RequestParam String email) {
        try {
            this.emailService.sendSimpleMessage(email, "Welcome", "Test message!");
        }
        catch (MailException mailException) {
            mailException.printStackTrace();
            return new ResponseEntity((Object)"Unable send email", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)"Check Inbox", HttpStatus.OK);
    }
}

