/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import ru.linologi.core.scp.srv.ParamLoadSrv;

@Controller
@RequestMapping(value={"/api/v2/fileloader"})
public class FileLoaderController {
    private final ParamLoadSrv paramLoadSrv;
    private static final Logger log = LoggerFactory.getLogger(FileLoaderController.class);

    public FileLoaderController(ParamLoadSrv paramLoadSrv) {
        this.paramLoadSrv = paramLoadSrv;
    }

    @GetMapping(value={"/{fileName}"})
    public ResponseEntity<Resource> getSavedJobFile(@PathVariable String fileName) throws IOException {
        FileSystemResource file = new FileSystemResource(this.paramLoadSrv.getStringParam("eyeprint.ps.converted.path") + fileName);
        if (!file.exists()) {
            log.error("File not found!");
            throw new FileNotFoundException("File not found!");
        }
        String contentType = null;
        try {
            contentType = URLConnection.guessContentTypeFromName(file.getFile().getName());
        }
        catch (Exception e) {
            log.error("Content type is not defined!");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }
}

