/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.DeviceGroup;
import ru.interunity.ep.web.dao.DeviceGroupDao;
import ru.interunity.ep.web.dto.DeviceGroupBind;

@RestController
@RequestMapping(value={"/api/v2/device-group"})
public class DeviceGroupController {
    private final DeviceGroupDao deviceGroupDao;

    @GetMapping(value={"/list"})
    public List<DeviceGroup> getGroupList() {
        return this.deviceGroupDao.findAll();
    }

    @GetMapping(value={"/device/{id}"})
    public List<DeviceGroup> getDeviceGroupList(@PathVariable Long id) {
        return this.deviceGroupDao.getDeviceGroups(id.longValue());
    }

    @PostMapping(value={"/bind-device-group"})
    public ResponseEntity<String> bindDeviceGroup(@RequestBody DeviceGroupBind deviceGroup) {
        try {
            this.deviceGroupDao.bindDeviceToGroup(deviceGroup.getDeviceId().longValue(), deviceGroup.getGroupId().longValue());
            return ResponseEntity.ok((Object)"{\"success\": true}");
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)"{\"success\": false}");
        }
    }

    @PostMapping(value={"/unbind-device-group"})
    public ResponseEntity<String> unbindDeviceGroup(@RequestBody DeviceGroupBind deviceGroup) {
        try {
            this.deviceGroupDao.unbindDeviceToGroup(deviceGroup.getDeviceId().longValue(), deviceGroup.getGroupId().longValue());
            return ResponseEntity.ok((Object)"{\"success\": true}");
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)"{\"success\": false}");
        }
    }

    @PostMapping(value={"/save-group"})
    public ResponseEntity<Void> saveGroup(@RequestBody DeviceGroup deviceGroup) {
        this.deviceGroupDao.writeDeviceGroup(deviceGroup);
        return ResponseEntity.ok().build();
    }

    public DeviceGroupController(DeviceGroupDao deviceGroupDao) {
        this.deviceGroupDao = deviceGroupDao;
    }
}

