/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.widget.widgets;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.interunity.ep.dto.PrintJob;
import ru.interunity.ep.web.widget.IWidget;
import ru.interunity.ep.web.widget.WidgetData;
import ru.interunity.ep.web.widget.WidgetItem;
import ru.interunity.ep.web.widget.WidgetTemplate;

public class WeeklyPrintJobWidget
implements IWidget {
    public WidgetData getData(WidgetTemplate template) {
        LocalDate now;
        LocalDate mondey = now = LocalDate.now().minusDays(4L);
        if (now.getDayOfWeek() != DayOfWeek.MONDAY) {
            int daysToSubtract = now.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue();
            mondey = now.minusDays(daysToSubtract);
        }
        HashMap<String, WidgetItem> map = new HashMap<String, WidgetItem>();
        List jobs = template.getPrintJobDao().getReportByDate(LocalDateTime.of(mondey.getYear(), mondey.getMonth(), mondey.getDayOfMonth(), 0, 0), LocalDateTime.of(now.getYear(), now.getMonth(), now.getDayOfMonth(), 23, 59));
        LinkedHashMap<LocalDate, Integer> mapJob = new LinkedHashMap<LocalDate, Integer>();
        for (PrintJob printJob : jobs) {
            LocalDate date = printJob.getJobStartTime().toLocalDate();
            if (mapJob.containsKey(date)) {
                mapJob.put(date, (Integer)mapJob.get(date) + 1);
                continue;
            }
            mapJob.put(date, 1);
        }
        for (Map.Entry entry : mapJob.entrySet()) {
            map.put(((LocalDate)entry.getKey()).toString(), WidgetItem.builder().itemColor("green").legendName(((LocalDate)entry.getKey()).getDayOfWeek().toString()).itemValue((double)((Integer)entry.getValue()).intValue()).build());
        }
        return WidgetData.builder().name("\u041e\u0431\u044a\u0435\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430 \u043d\u0435\u0434\u0435\u043b\u044e").widgetItems(map).build();
    }
}

