/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.srv;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.interunity.ep.web.srv.JdbcSqlInit;

@Component
public class JdbcSqlInit {
    private static final Logger log = LoggerFactory.getLogger(JdbcSqlInit.class);
    private final JdbcTemplate jdbcTemplate;
    Connection con;
    Map<String, String> config;
    boolean iscon;

    public JdbcSqlInit(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @PostConstruct
    public void conInit() {
        try {
            this.con = this.jdbcTemplate.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDevListHtml() {
        AtomicReference<String> jwr = new AtomicReference<String>("");
        this.jdbcTemplate.query("SELECT printers.*, INET_NTOA(printers.ip) as ipS, iana.vendor as vn, timestamp(timestamp(printers.date_last)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, timestamp(timestamp(printers.date_born)+timestamp(CONCAT('0000-00-00 0', (select value from properties where parameter='timeZone' ), ':00:00'))) as timeBr FROM printers INNER JOIN iana ON iana.id=printers.vendor WHERE printers.deleted!=1 or printers.deleted is null  ORDER BY printers.state DESC", rs -> {
            while (rs.next()) {
                int idDev = rs.getInt("id");
                jwr.set((String)jwr.get() + "<div id='dev_" + idDev + "' class='elem");
                String stateDev = "";
                if (rs.getInt("state") == 1) {
                    jwr.set((String)jwr.get() + " on");
                    stateDev = this.getStatusDevice(idDev);
                } else {
                    jwr.set((String)jwr.get() + " off");
                    stateDev = "<img src='images/down.png' title='Offline' class='status'>";
                }
                jwr.set((String)jwr.get() + "'><table class='elemTable'><tr><td valign=top><img src='images/device.jpg' class='device on'>" + stateDev + "</td><td><table class='elemTableData'><tr><td class='name'><div class='nameCut' title='" + rs.getString("name") + "'>" + rs.getString("name") + "</div></td></tr><tr><td>" + rs.getString("sn") + "</td></tr><tr><td>" + rs.getString("counter") + "</td></tr><tr><td>" + rs.getString("ipS") + "</td></tr><tr><td style='text-transform:uppercase; font-family: Courier;' >" + rs.getString("macAddress") + "</td></tr></table></td><tr></table>");
                jwr.set((String)jwr.get() + this.getSupDevHtml(idDev) + "</div>");
            }
            return null;
        });
        return jwr.get();
    }

    public JSONObject getDevListArr() {
        JSONObject jwr = new JSONObject();
        this.jdbcTemplate.query("SELECT printers.*, INET_NTOA(printers.ip) as ipS, iana.vendor as vn, timestamp(timestamp(printers.date_last)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, timestamp(timestamp(printers.date_born)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeBr FROM printers INNER JOIN iana ON iana.id=printers.vendor WHERE printers.deleted !=1 or printers.deleted is null", rs -> {
            while (rs.next()) {
                JSONArray line = new JSONArray();
                line.add((Object)rs.getString("id"));
                line.add((Object)rs.getString("macAddress"));
                line.add((Object)rs.getString("vendor"));
                line.add((Object)rs.getString("name"));
                line.add((Object)rs.getString("sn").trim());
                line.add((Object)rs.getString("ipS"));
                line.add((Object)rs.getString("9100"));
                line.add((Object)rs.getString("515"));
                line.add((Object)rs.getString("631"));
                line.add((Object)rs.getString("snmp"));
                line.add((Object)rs.getString("CommunityName"));
                line.add((Object)rs.getString("timeBr"));
                line.add((Object)rs.getString("timeST"));
                line.add((Object)rs.getString("state"));
                line.add((Object)rs.getString("deleted"));
                line.add((Object)rs.getString("printTech"));
                line.add((Object)rs.getString("format"));
                line.add((Object)rs.getString("color"));
                line.add((Object)rs.getString("counter"));
                line.add((Object)rs.getString("vn"));
                jwr.put((Object)rs.getString("id"), (Object)line);
            }
            return null;
        });
        return jwr;
    }

    public String aGetProp() {
        AtomicReference<String> jwl = new AtomicReference<String>("<div id='out'><table border=0 cellspacing=0 cellpadding=0>\t\t\t<tr><td></td><td></td></tr>");
        this.jdbcTemplate.query("SELECT properties.* FROM properties where description!=''", rs -> {
            while (rs.next()) {
                jwl.set(jwl + "<tr><td style='border-bottom:1px #aaa dotted;'>" + rs.getString("description") + "</td><td style='border-bottom:1px #aaa dotted;'><input class='ips1' type='text' id='" + rs.getString("parameter") + "' value='" + rs.getString("prop_value") + "' class='im' ></td></tr>");
            }
            return null;
        });
        jwl.set(jwl + "</table></div>");
        return jwl.get();
    }

    public int getParam(String pramName) {
        AtomicInteger statParam = new AtomicInteger();
        this.jdbcTemplate.query("SELECT prop_value FROM properties WHERE parameter = ? ", rs -> {
            if (rs.next()) {
                statParam.set(rs.getInt("prop_value"));
            }
            return null;
        }, new Object[]{pramName});
        return statParam.get();
    }

    public Map getParamForDevInfo(int idDev) {
        HashMap listDevInfo = new HashMap();
        this.jdbcTemplate.query("SELECT macAddress, sn, name, inet_ntoa(ip) as ips FROM printers WHERE id= ?", rs -> {
            if (rs.next()) {
                listDevInfo.put("ip", rs.getString("ips"));
                listDevInfo.put("name", rs.getString("name"));
                listDevInfo.put("sn", rs.getString("sn"));
                listDevInfo.put("mac", rs.getString("macAddress"));
            }
            return null;
        }, new Object[]{idDev});
        return listDevInfo;
    }

    public Map getCodeDescr(String nameGroup) {
        HashMap listDescr = new HashMap();
        this.jdbcTemplate.query("SELECT * FROM codDesc WHERE \"group\" = ?", rs -> {
            while (rs.next()) {
                listDescr.put(rs.getString("idInGroup"), rs.getString("description"));
            }
            return null;
        }, new Object[]{nameGroup});
        return listDescr;
    }

    public String getSupReportsInDev(int idDev) {
        List listSupInDev = this.getSupInDev(idDev);
        Object forRet = "";
        for (int i = 0; i < listSupInDev.size(); ++i) {
            forRet = (String)forRet + this.getRepForSuppUnit(idDev, (String[])listSupInDev.get(i));
        }
        return forRet;
    }

    private List getSupInDev(int idDev) {
        1 listSupInDev = new /* Unavailable Anonymous Inner Class!! */;
        this.jdbcTemplate.query("SELECT type, color FROM suppliesLog WHERE devID= ? GROUP BY suppliesLog.type, suppliesLog.color", arg_0 -> JdbcSqlInit.lambda$getSupInDev$6((ArrayList)listSupInDev, arg_0), new Object[]{idDev});
        return listSupInDev;
    }

    private String getRepForSuppUnit(int idDev, String[] typCol) {
        Map supTypeRef = this.getCodeDescr("PrtMarkerSuppliesType");
        AtomicReference<Double> prev = new AtomicReference<Double>(0.0);
        AtomicReference<Double> all = new AtomicReference<Double>(0.0);
        AtomicReference<String> forRet = new AtomicReference<String>("");
        AtomicReference<String> lineChanget = new AtomicReference<String>("");
        AtomicReference<String> oldSn = new AtomicReference<String>("");
        this.jdbcTemplate.query("SELECT  val, timeInsert, snSupp FROM suppliesLog where timeInsert>'2016-04-24' AND devID= ? and type= ? and color= ? order by id  ", rs -> {
            if (rs.next()) {
                prev.set(rs.getDouble("val"));
                oldSn.set(rs.getString("snSupp"));
            }
            String dateFirstData = "";
            boolean dateSet = false;
            boolean first = true;
            while (rs.next()) {
                if (!dateSet) {
                    dateFirstData = rs.getString("timeInsert");
                    dateSet = true;
                }
                double raz = 0.0;
                String valString = rs.getString("val");
                if (valString.contains(",")) {
                    valString = valString.replace(",", ".");
                }
                double val = Double.parseDouble(valString);
                if ((Double)prev.get() >= val) {
                    raz = (Double)prev.get() - val;
                } else {
                    if (first) {
                        lineChanget.set("<tr class='changeS'><td colspan='3'>\u0417\u0430\u043c\u0435\u043d\u044b</td></tr>");
                        first = false;
                    }
                    lineChanget.set(lineChanget + "<tr class='changeRow'><td></td><td>" + rs.getString("timeInsert") + "</td><td>" + prev + "% -> " + val + "% ");
                    if (!((String)oldSn.get()).isEmpty() || !rs.getString("snSupp").equals("")) {
                        lineChanget.set(lineChanget + " (" + oldSn + "-->>" + rs.getString("snSupp") + ")");
                    }
                    lineChanget.set(lineChanget + "</td></tr>");
                    raz = 0.0;
                }
                all.set((Double)all.get() + raz);
                prev.set(val);
                oldSn.set(rs.getString("snSupp"));
            }
            if ((Double)all.get() != 0.0) {
                forRet.set(forRet + "<tr class='supUnit'><td><b>" + supTypeRef.get(typCol[0]) + "<b></td><td>" + typCol[1] + "</td><td> \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e  " + (Double)all.get() / 100.0 + " \u0435\u0434. (\u0417\u0430 \u043f\u0435\u0440\u0435\u0438\u043e\u0434 \u0441 " + dateFirstData + ")</td></tr>" + lineChanget);
            }
            return null;
        }, new Object[]{idDev, typCol[0], typCol[1]});
        return forRet.get();
    }

    public String getSupReportsAllDev() {
        AtomicReference<String> forRet = new AtomicReference<String>("");
        this.jdbcTemplate.query("SELECT id, name FROM printers", rs -> {
            while (rs.next()) {
                forRet.set(forRet + rs.getString("name") + "<br>");
                forRet.set(forRet + this.getSupReportsInDev(rs.getInt("id")));
            }
            return null;
        });
        return forRet.get();
    }

    public JSONObject getSup(int idDev, int type, String color) {
        JSONObject container = new JSONObject();
        AtomicInteger ind = new AtomicInteger();
        this.jdbcTemplate.query("SELECT timeInsert, val FROM suppliesLog WHERE devId= ? and color= ? and type= ? and CAST(REPLACE(val, ',', '.') AS DOUBLE PRECISION) >=0  ORDER BY timeInsert", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getTimestamp("timeInsert").toString());
                item.add((Object)rs.getString("val"));
                container.put((Object)ind, (Object)item);
                ind.getAndIncrement();
            }
        }, new Object[]{idDev, color, String.valueOf(type)});
        return container;
    }

    public JSONArray getSup(int idDev, int type, String color, String dateBegin, String dateEnd) {
        JSONArray container = new JSONArray();
        this.jdbcTemplate.query("SELECT timeInsert, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM suppliesLog WHERE devId= ? and color= ? and type= ? and val>=0 and timeInsert > ? and timeInsert < ? ORDER BY timeInsert", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("timeST"));
                item.add((Object)Float.valueOf(rs.getFloat("val")));
                container.add((Object)item);
            }
        }, new Object[]{idDev, color, type, dateBegin, dateEnd});
        return container;
    }

    public JSONArray getSup(int idDev, int type, String color, String date, int datetype) {
        String query = "";
        if (datetype == 1) {
            query = "`timeInsert`>";
        }
        if (datetype == 2) {
            query = "`timeInsert`<";
        }
        JSONArray container = new JSONArray();
        this.jdbcTemplate.query("SELECT timeInsert, timestamp(timestamp(timeInsert)+timestamp(CONCAT('0000-00-00 0', (select prop_value from properties where parameter='timeZone' ), ':00:00'))) as timeST, val FROM `suppliesLog` WHERE devId= ? and color= ? and type= ? and val>=0 and " + query + " ?  ORDER BY timeInsert", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("timeST"));
                item.add((Object)Float.valueOf(rs.getFloat("val")));
                container.add((Object)item);
            }
        }, new Object[]{idDev, color, type, date});
        return container;
    }

    public JSONObject getSupUnit(int idDev) {
        JSONArray container = new JSONArray();
        JSONObject jo = new JSONObject();
        AtomicInteger ind = new AtomicInteger(0);
        this.jdbcTemplate.query("SELECT supplieslog.type as type, supplieslog.color as color , supplies_type.nameRus as nameRus FROM supplieslog LEFT JOIN  supplies_type ON CAST(supplieslog.type AS INTEGER) = supplies_type.id WHERE devId = ? AND CAST(suppliesLog.type AS INTEGER) not in (4, 10, 1) GROUP BY \"type\", color, supplies_type.namerus", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("type"));
                item.add((Object)rs.getString("color"));
                item.add((Object)rs.getString("nameRus"));
                container.add((Object)item);
                jo.put((Object)ind.get(), (Object)item);
                ind.getAndIncrement();
            }
            return null;
        }, new Object[]{idDev});
        return jo;
    }

    public JSONArray getCounterLog(int idDev) {
        JSONArray container = new JSONArray();
        this.jdbcTemplate.query("SELECT counterLog.*, timeSetValue FROM counterLog WHERE idDev = ? ORDER BY timeSetValue", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("timeSetValue"));
                item.add((Object)rs.getInt("counterValue"));
                container.add((Object)item);
            }
            return null;
        }, new Object[]{idDev});
        return container;
    }

    public JSONArray getCounterLog(int idDev, String dateBegin, String dateEnd) {
        JSONArray container = new JSONArray();
        this.jdbcTemplate.query("SELECT * FROM counterLog WHERE idDev = ? and timeSetValue> ? and timeSetValue< ? ORDER BY timeSetValue", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("timeSetValue"));
                item.add((Object)rs.getInt("counterValue"));
                container.add((Object)item);
            }
        }, new Object[]{idDev, dateBegin, dateEnd});
        return container;
    }

    public JSONArray getCounterLog(int idDev, String date, int dateType) {
        String partOfQuery = "";
        if (dateType == 1) {
            partOfQuery = "and timeSetValue>";
        }
        if (dateType == 2) {
            partOfQuery = "and timeSetValue<";
        }
        JSONArray container = new JSONArray();
        this.jdbcTemplate.query("SELECT counterLog.*, timeSetValue FROM counterLog WHERE idDev = ? " + partOfQuery + "?ORDER BY timeSetValue ", rs -> {
            while (rs.next()) {
                JSONArray item = new JSONArray();
                item.add((Object)rs.getString("timeSetValue"));
                item.add((Object)rs.getInt("counterValue"));
                container.add((Object)item);
            }
        }, new Object[]{idDev, date});
        return container;
    }

    public String getListNetDiap() {
        StringBuilder forRet = new StringBuilder();
        this.jdbcTemplate.query("SELECT * FROM ips", rs -> {
            while (rs.next()) {
                forRet.append("<div class='line'><span id='del_" + rs.getString("id") + "' class='del'>x</span>&nbsp;&nbsp;<span id='range_" + rs.getString("id") + "' class='range'>" + rs.getString("ip_from") + "-" + rs.getString("ip_to") + "</span></div>");
            }
            return null;
        });
        return forRet.toString();
    }

    public void addNetDiap(String ipFrom, String ipTo) {
        this.jdbcTemplate.update("INSERT INTO ips SET ip_from = ?, ip_to = ?", new Object[]{ipFrom, ipTo});
    }

    public void delNetDiap(int idDiap) {
        this.jdbcTemplate.update("DELETE FROM ips WHERE id = ?", new Object[]{idDiap});
    }

    public void setParam(String parameter, String value) {
        this.jdbcTemplate.update("UPDATE properties SET prop_value = ? WHERE parameter = ?", new Object[]{value, parameter});
    }

    public JSONArray getAlert(String devId, String dateBegine, String dateEnd) {
        String query = "SELECT * FROM alertLog WHERE devId = ? AND TimeInsert < ?  AND TimeInsert > ? ";
        JSONArray arr = new JSONArray();
        this.jdbcTemplate.query(query, rs -> {
            while (rs.next()) {
                JSONArray row = new JSONArray();
                row.add((Object)rs.getTimestamp("TimeInsert"));
                row.add((Object)rs.getInt("id"));
                row.add((Object)rs.getInt("hrDeviceIndex"));
                row.add((Object)rs.getString("prtAlertIndex"));
                row.add((Object)rs.getString("prtAlertSeverityLevel"));
                row.add((Object)rs.getString("prtAlertTrainingLevel"));
                row.add((Object)rs.getString("prtAlertGroup"));
                row.add((Object)rs.getString("prtAlertGroupIndex"));
                row.add((Object)rs.getString("prtAlertLocation"));
                row.add((Object)rs.getString("prtAlertCode"));
                row.add((Object)rs.getString("prtAlertDescription"));
                row.add((Object)rs.getString("prtAlertTime"));
                row.add((Object)rs.getTimestamp("alertEnd"));
                row.add((Object)rs.getInt("life"));
                arr.add((Object)row);
            }
        }, new Object[]{Integer.parseInt(devId), Timestamp.valueOf(LocalDateTime.parse(dateEnd + " 23:59:59", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))), Timestamp.valueOf(LocalDateTime.parse(dateBegine + " 00:00:01", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))});
        return arr;
    }

    String getFullReport(int idDev) {
        AtomicReference<String> forRet = new AtomicReference<String>("<table>");
        this.jdbcTemplate.query("SELECT * FROM suppliesLog WHERE Devid= ?", rs1 -> {
            while (rs1.next()) {
                this.jdbcTemplate.query("SELECT counterValue, timeSetValue FROM counterLog WHERE idDev= ? and timeSetValue <'" + rs1.getString("timeInsert") + "' ORDER BY timeSetValue DESC LIMIT 1", rs2 -> {
                    if (rs2.next()) {
                        forRet.set(forRet + "<tr><td>" + rs1.getString("description") + "</td><td>" + rs1.getString("val") + "</td><td>" + rs1.getString("timeInsert") + "</td><td>" + rs2.getString("counterValue") + "</td><td>" + rs2.getString("timeSetValue") + "</td></tr>");
                    }
                    return null;
                }, new Object[]{idDev});
            }
            return null;
        }, new Object[]{idDev});
        return forRet + "</table>";
    }

    public String getCounterReport(String dateBegine, String dateEnd) {
        AtomicReference<CallSite> forRet = new AtomicReference<CallSite>((CallSite)((Object)("<table class='kumulative'><thead><font size='+1'><b>\u0421\u0432\u043e\u0434\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442 \u0441 " + dateBegine.split(" ")[0] + " \u043f\u043e " + dateEnd.split(" ")[0] + "</b></font></thead>")));
        this.jdbcTemplate.query("SELECT printers.id as devId, printers.name as devName, INET_NTOA(printers.ip) as devIp, zap1.re, zap1.st, zap1.fn FROM printers INNER JOIN (SELECT idDev, MAX(counterValue) as fn, MIN(counterValue) as st, (MAX(counterValue)-MIN(counterValue)) as re FROM counterLog WHERE timeSetValue >'2017-09-01' and timeSetValue < '2023-09-19' GROUP BY idDev ) zap1 ON zap1.idDEv = printers.id ORDER BY re DESC", rs1 -> {
            while (rs1.next()) {
                forRet.set((CallSite)((Object)(forRet + "<tr><td>" + rs1.getString("devId") + "</td><td align='right'>" + rs1.getString("devIp") + "</td><td>" + rs1.getString("devName") + "</td><td>" + rs1.getString("st") + "</td><td>" + rs1.getString("fn") + "</td><td align='right'>" + rs1.getString("re") + "</td></tr>")));
            }
            return null;
        });
        return forRet + "</table>";
    }

    private String getSupDevHtml(int idDev) {
        HashMap<String, String> colorListRus = new HashMap<String, String>();
        colorListRus.put("magenta", "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u044b\u0439");
        colorListRus.put("yellow", "\u0416\u0435\u043b\u0442\u044b\u0439");
        colorListRus.put("cyan", "\u0413\u043e\u043b\u0443\u0431\u043e\u0439");
        colorListRus.put("clear", "\u041b\u0430\u043a");
        colorListRus.put("black", "\u0427\u0435\u0440\u043d\u044b\u0439");
        colorListRus.put("white", "\u0411\u0435\u043b\u044b\u0439");
        HashMap<String, String> colorListClass = new HashMap<String, String>();
        colorListClass.put("magenta", "tonerMagenta");
        colorListClass.put("yellow", "tonerYellow");
        colorListClass.put("cyan", "tonerCyan");
        colorListClass.put("clear", "tonerClear");
        colorListClass.put("black", "tonerBlack");
        colorListClass.put("white", "tonerWhite");
        AtomicReference<String> tb = new AtomicReference<String>("<table class='elemTable'>");
        this.jdbcTemplate.query("SELECT suppliesLog.id, suppliesLog.type, suppliesLog.color, suppliesLog.val FROM suppliesLog RIGHT JOIN (SELECT max(suppliesLog.id) as id FROM suppliesLog WHERE suppliesLog.devId = ? AND suppliesLog.type IN (3, 6, 5) GROUP BY suppliesLog.type, suppliesLog.color) as zap1 ON suppliesLog.id=zap1.id", rs -> {
            while (rs.next()) {
                String val = "data-lowToner='false'";
                if (rs.getInt("val") < this.getParam("alertSupp")) {
                    val = "data-lowToner='true'";
                }
                tb.set((String)tb.get() + "<tr><td>" + colorListRus.get(rs.getString("color").toLowerCase()) + "</td><td><div title='" + rs.getInt("val") + "%' class='progress " + colorListClass.get(rs.getString("color").toLowerCase()) + "' data-value='" + rs.getInt("val") + "' " + val + " data-color='" + rs.getString("color").toLowerCase() + "'></div></td></tr> ");
            }
            return null;
        }, new Object[]{idDev});
        return tb.get() + "</table>";
    }

    private String getStatusDevice(int idDev) {
        AtomicReference<String> pathSrc = new AtomicReference<String>("'images/ok.png'");
        AtomicReference<String> altImg = new AtomicReference<String>("");
        this.jdbcTemplate.query("SELECT * FROM alertLog WHERE devId = ? AND alertEnd is NULL AND prtAlertTrainingLevel IN (4, 5, 6);", rs -> {
            while (rs.next()) {
                pathSrc.set("'images/alert.png'");
                altImg.set(rs.getString("prtAlertDescription"));
            }
            return null;
        }, new Object[]{idDev});
        return "<img src=" + pathSrc + "  title='" + altImg + "' class='status'>";
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Connection getCon() {
        return this.con;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean isIscon() {
        return this.iscon;
    }

    public void setCon(Connection con) {
        this.con = con;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void setIscon(boolean iscon) {
        this.iscon = iscon;
    }

    private static /* synthetic */ Object lambda$getSupInDev$6(ArrayList listSupInDev, ResultSet rs) throws SQLException, DataAccessException {
        while (rs.next()) {
            String[] typCol = new String[]{rs.getString("type"), rs.getString("color")};
            listSupInDev.add(typCol);
        }
        return null;
    }
}

