/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.srv;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;
import ru.interunity.ep.web.dto.ReportExcelRs;
import ru.interunity.ep.web.dto.ReportRs;
import ru.interunity.ep.web.srv.ExcelFileProcessor;
import ru.linologi.core.scp.srv.ParamLoadSrv;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ExcelReportProcessor {
    private final ParamLoadSrv paramLoadSrv;

    public ExcelReportProcessor(ParamLoadSrv paramLoadSrv) {
        this.paramLoadSrv = paramLoadSrv;
    }

    public ReportExcelRs process(ReportRs reportRs) {
        AtomicInteger rowIndex = new AtomicInteger(0);
        ReportExcelRs rs = ReportExcelRs.builder().build();
        rs.setFileName(UUID.randomUUID() + ".xlsx");
        HashMap<Integer, Integer> width = new HashMap<Integer, Integer>();
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFSheet sheet = workbook.createSheet();
            XSSFRow headerRow = sheet.createRow(rowIndex.getAndIncrement());
            int column = 0;
            for (ReportRs.ReportHeader header : reportRs.getHeaders()) {
                XSSFCell coll = headerRow.createCell(column);
                coll.setCellValue(header.getColumnName());
                this.widthRather(column, width, (Cell)coll);
                ++column;
            }
            reportRs.getItems().forEach(item -> {
                try {
                    Map props = ExcelReportProcessor.convertToMap((Object)item);
                    int columnIn = 0;
                    XSSFRow row = sheet.createRow(rowIndex.getAndIncrement());
                    for (ReportRs.ReportHeader rowItem : reportRs.getHeaders()) {
                        Cell coll = row.createCell(columnIn);
                        coll.setCellValue(props.get(rowItem.getFieldName()).toString());
                        this.widthRather(columnIn, width, coll);
                        ++columnIn;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            });
            width.forEach((arg_0, arg_1) -> ((XSSFSheet)sheet).setColumnWidth(arg_0, arg_1));
            ExcelFileProcessor.writeWorkbook((Workbook)workbook, (String)this.paramLoadSrv.getStringParam("eyeprint.web.report.store", "/opt/eyeprint/storage/pdf/"), (String)rs.getFileName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rs;
    }

    public static Map<String, Object> convertToMap(Object obj) throws IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                JsonProperty jsonProp = field.getAnnotation(JsonProperty.class);
                field.setAccessible(true);
                if (jsonProp != null) {
                    resultMap.put(jsonProp.value(), field.get(obj));
                    continue;
                }
                resultMap.put(field.getName(), field.get(obj));
            }
        }
        return resultMap;
    }

    private void widthRather(int columnIn, Map<Integer, Integer> width, Cell coll) {
        if (!width.containsKey(columnIn)) {
            width.put(columnIn, 256 * coll.getStringCellValue().length());
        } else if (width.get(columnIn) < coll.getStringCellValue().length() * 256) {
            width.remove(columnIn);
            width.put(columnIn, 256 * coll.getStringCellValue().length());
        }
    }
}

