/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import ru.interunity.ep.web.dao.UserGroupDao;
import ru.interunity.ep.web.dto.UserGroupDto;
import ru.linologi.auth.dto.User;

@Service
public class UserGroupService {
    private final UserGroupDao userGroup;

    public UserGroupService(UserGroupDao userGroup) {
        this.userGroup = userGroup;
    }

    public ResponseEntity<UserGroupDto> addNewGroup(UserGroupDto ugd) {
        if (StringUtils.isEmpty((CharSequence)ugd.getDescription())) {
            ugd.setDescription("no data");
        }
        try {
            UserGroupDto newGroup = this.userGroup.addNewGroup(ugd);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)newGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
    }

    public ResponseEntity<List<UserGroupDto>> getAllGroups() {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.userGroup.getAllGroups());
    }

    public ResponseEntity<UserGroupDto> getGroupById(Integer id) {
        UserGroupDto group = this.userGroup.getGroupById(id);
        return group.getId() != -1 ? ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)group) : ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)group);
    }

    public ResponseEntity<String> updateGroup(UserGroupDto ugd) {
        try {
            return this.userGroup.updateGroup(ugd) != 0 ? ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Group updated") : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Group with id " + ugd.getId() + " not found"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    public ResponseEntity<String> deleteGroupById(Integer id) {
        return this.userGroup.deleteGroupById(id) != 0 ? ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Group deleted") : ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Group with id " + id + " not found"));
    }

    public ResponseEntity<String> addUserGroupRelation(Integer userId, Integer groupId) {
        try {
            this.userGroup.addUserGroupRelation(userId, groupId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Create relation: user id = " + userId + " and group id = " + groupId));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    public ResponseEntity<String> deleteUserGroupRelation(Integer userId, Integer groupId) {
        if (this.userGroup.checkUserGroupRelation(userId, groupId) != 0) {
            this.userGroup.deleteUserGroupRelation(userId, groupId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Delete relation: user id = " + userId + " and group id = " + groupId));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Relation not found");
    }

    public ResponseEntity<List<UserGroupDto>> getUserGroupsById(Integer id) {
        List groups = this.userGroup.getUserGroupsById(Long.valueOf(id.intValue()));
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)groups);
    }

    public ResponseEntity<List<User>> getGroupUsersById(Integer groupId) {
        List usersId = this.userGroup.getGroupUsersById(groupId);
        return usersId.isEmpty() ? ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)usersId) : ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)usersId);
    }

    public ResponseEntity<List<UserGroupDto>> getAllGroupsWithUsers() {
        List groupWithUsers = this.userGroup.getAllGroupsWithUsers();
        return groupWithUsers.isEmpty() ? ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build() : ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)groupWithUsers);
    }

    public ResponseEntity<Map<Long, List<UserGroupDto>>> getAllUsersWithGroup() {
        Map usersWithGroups = this.userGroup.getAllUsersWithGroup();
        return usersWithGroups.isEmpty() ? ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build() : ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)usersWithGroups);
    }
}

