/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import org.springframework.stereotype.Component;
import ru.interunity.ep.dao.SnmpCredentialDao;
import ru.interunity.ep.dto.printer.SnmpCredentialDto;

@Component
public class SnmpCredentialService {
    private final SnmpCredentialDao snmpCredentialDao;

    public SnmpCredentialDto getSnmpCredential(long printerId) {
        try {
            return this.snmpCredentialDao.getSnmpCredential(printerId);
        }
        catch (Exception ex) {
            return SnmpCredentialDto.builder().community("public").port(161).version("v2").build();
        }
    }

    public void saveSnmpCredential(SnmpCredentialDto snmpCredentialDto) {
        this.snmpCredentialDao.save(snmpCredentialDto);
    }

    public void deleteSnmpCredential(long printerId) {
        this.snmpCredentialDao.delete(printerId);
    }

    public SnmpCredentialService(SnmpCredentialDao snmpCredentialDao) {
        this.snmpCredentialDao = snmpCredentialDao;
    }
}

