/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ScpFileDownloadService {
    @Value(value="${download.path}")
    private String directory;
    private static final Logger log = LoggerFactory.getLogger(ScpFileDownloadService.class);

    public String download(String username, String password, String host, String remoteFilePath) {
        if (!Files.exists(Paths.get(this.directory, new String[0]), new LinkOption[0])) {
            log.info("Local directory does not exist: " + this.directory);
            return null;
        }
        File localFile = null;
        try {
            SftpATTRS sftpATTRS;
            JSch jsch = new JSch();
            Session session = jsch.getSession(username, host);
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setTimeout(1000);
            session.connect();
            ChannelSftp channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            try {
                sftpATTRS = channelSftp.stat(remoteFilePath);
            }
            catch (Exception exp) {
                log.info("File not exist");
                return null;
            }
            if (!sftpATTRS.isDir()) {
                localFile = new File(this.directory + remoteFilePath.substring(remoteFilePath.lastIndexOf("/") + 1));
                FileOutputStream fileOutputStream = new FileOutputStream(localFile);
                channelSftp.get(remoteFilePath, (OutputStream)fileOutputStream);
                log.info("File downloaded successfully!");
            } else {
                log.info("Remote file path is directory: " + remoteFilePath);
            }
            channelSftp.disconnect();
            session.disconnect();
        }
        catch (JSchException | SftpException | FileNotFoundException e) {
            e.printStackTrace();
        }
        return localFile != null ? localFile.getAbsolutePath() : null;
    }
}

