/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.dto.AlertDeviceDto;
import ru.interunity.ep.dto.ColorSuppliesDto;
import ru.interunity.ep.dto.Device;
import ru.interunity.ep.web.dao.AlertDao;
import ru.interunity.ep.web.dao.DeviceGroupDao;
import ru.interunity.ep.web.dao.SuppliesDao;
import ru.interunity.ep.web.service.PrinterService;

@Component
public class PrinterServiceImpl
implements PrinterService {
    private final PrinterDao printerDao;
    private final SuppliesDao suppliesDao;
    private final AlertDao alertDao;
    private final DeviceGroupDao deviceGroupDao;
    private static final String _a564cdb0_cab3_4d39_8181_9786ea6017a1 = "69,110,118,107,77,107,66,57,47,52,84,103,122,76,114,47,51,110,116,65,56,70,65,107,72,109,77,109,74,88,103,109,103,117,99,119,108,72,107,122,65,116,83,106,88,100,98,67,74,119,48,103,101,102,79,100,10,43,119,113,114,68,54,84,97,113,116,55,53,105,47,69,117,119,118,98,98,115,113,119,50,68,68,57,55,114,68,75,50,81,51,118,110,83,99,80,105,77,77,65,89,76";

    public PrinterServiceImpl(PrinterDao printerDao, SuppliesDao suppliesDao, AlertDao alertDao, DeviceGroupDao deviceGroupDao) {
        this.printerDao = printerDao;
        this.suppliesDao = suppliesDao;
        this.alertDao = alertDao;
        this.deviceGroupDao = deviceGroupDao;
    }

    public List<Device> getAllPrinters() {
        return this.printerDao.getDevList();
    }

    public List<Device> getPrintersWithSuppliesLevel() {
        List devList = this.printerDao.getDevList();
        List colors = this.suppliesDao.getAllColorSuppliesLevel();
        devList.forEach(device -> {
            device.setGroupIds(this.deviceGroupDao.getDeviceGroupIds(device.getId()));
            device.setSeverity(this.getSeverity(device));
            colors.forEach(color -> {
                if ((long)color.getDevId() == device.getId()) {
                    if (device.getColorsSupLevel().containsKey(color.getColor().getEnColor())) {
                        if (((ColorSuppliesDto)device.getColorsSupLevel().get(color.getColor().getEnColor())).getId() < color.getId()) {
                            device.getColorsSupLevel().put(color.getColor().getEnColor(), color);
                        }
                    } else {
                        device.getColorsSupLevel().put(color.getColor().getEnColor(), color);
                    }
                }
            });
        });
        return devList;
    }

    public void setAliases(Long deviceId, String alias) {
        this.printerDao.setAliases(deviceId, alias);
    }

    private Device.Severity getSeverity(Device device) {
        List list = this.alertDao.activeAlerts(device.getId());
        Optional<String> severety = list.stream().map(AlertDeviceDto::getAlertSeverityLevel).sorted().findFirst();
        if (severety.isPresent()) {
            return Device.Severity.fromSeverity((String)severety.get());
        }
        return Device.Severity.NORMAL;
    }
}

