/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FtpFileDownloadService {
    @Value(value="${download.path}")
    private String directory;
    private static final Logger log = LoggerFactory.getLogger(FtpFileDownloadService.class);

    public FTPClient connect(String workDir, String login, String password, String host) {
        FTPClient ftpClient = new FTPClient();
        try {
            boolean success;
            ftpClient.connect(host);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                log.info("Operation failed with code: " + replyCode);
                ftpClient.disconnect();
            }
            if (!(success = ftpClient.login(login, password))) {
                ftpClient.disconnect();
            }
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            boolean changedRemoteDir = ftpClient.changeWorkingDirectory(workDir);
            if (!changedRemoteDir) {
                log.info("Directory is not found");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return ftpClient;
    }

    public String download(String login, String password, String host, String pathToFile) {
        if (!Files.exists(Paths.get(this.directory, new String[0]), new LinkOption[0])) {
            log.info("Local directory does not exist: " + this.directory);
            return null;
        }
        String filename = pathToFile.substring(pathToFile.lastIndexOf("/") + 1);
        String pathToFileInServer = pathToFile.substring(0, pathToFile.lastIndexOf("/"));
        FTPClient ftpClient = this.connect(pathToFileInServer, login, password, host);
        String absolutePath = "";
        try {
            FTPFile[] ftpFiles = ftpClient.listFiles();
            String downloadDir = this.directory;
            for (FTPFile file : ftpFiles) {
                if (!file.getName().equals(filename)) continue;
                File fileObj = new File(downloadDir + file.getName());
                if (file.isFile()) {
                    Path p = Files.createFile(fileObj.toPath(), new FileAttribute[0]);
                    absolutePath = p.toAbsolutePath().toString();
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(fileObj));
                    boolean isFileRetrive = ftpClient.retrieveFile(file.getName(), (OutputStream)outputStream);
                    ((OutputStream)outputStream).close();
                    continue;
                }
                log.info("The path passed is a folder: " + pathToFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return absolutePath.isEmpty() ? null : absolutePath;
    }
}

