/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.web.dto.StockChangeRs;
import ru.interunity.ep.web.dto.UserDeviceGroupBind;
import ru.interunity.ep.web.service.UserDeviceGroupService;
import ru.linologi.auth.dto.User;

@RestController
@RequestMapping(value={"/api/v2/user_device_group"})
public class UserDeviceGroupController {
    UserDeviceGroupService udgService;

    public UserDeviceGroupController(UserDeviceGroupService udgService) {
        this.udgService = udgService;
    }

    @PostMapping(value={"/add_bind"})
    public ResponseEntity<StockChangeRs> createBinding(@RequestBody UserDeviceGroupBind udg) {
        try {
            this.udgService.createBinding(udg);
            return ResponseEntity.ok((Object)StockChangeRs.success());
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)StockChangeRs.error((String)e.getMessage()));
        }
    }

    @DeleteMapping(value={"/unbind"})
    public ResponseEntity<StockChangeRs> unbind(@RequestBody UserDeviceGroupBind udg) {
        try {
            this.udgService.unbind(udg);
            return ResponseEntity.ok((Object)StockChangeRs.success());
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)StockChangeRs.error((String)e.getMessage()));
        }
    }

    @GetMapping(value={"/get_users/{id}"})
    public List<User> getUsersInDeviceGroup(@PathVariable long id) {
        return this.udgService.getUsersInDeviceGroup(id);
    }
}

