/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.time.LocalDateTime;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dao.PrinterDao;
import ru.interunity.ep.dto.SuppliesGetSupDto;
import ru.interunity.ep.dto.SuppliesUnit;
import ru.interunity.ep.web.dao.SuppliesDao;
import ru.interunity.ep.web.service.SuppliesService;

@RestController
@RequestMapping(value={"/api/v2/supplies"})
public class SuppliesController {
    private final SuppliesDao suppliesDao;
    private final PrinterDao printerDao;
    private final SuppliesService suppliesService;

    public SuppliesController(SuppliesDao suppliesDao, PrinterDao printerDao, SuppliesService suppliesService) {
        this.suppliesDao = suppliesDao;
        this.printerDao = printerDao;
        this.suppliesService = suppliesService;
    }

    @GetMapping(value={"/count-report"})
    public Object getCounterReport(@RequestParam(required=false) Integer idDev, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateStart) {
        if (idDev != null) {
            return this.suppliesDao.getSupReportsInDev(this.printerDao.getDevice(idDev), dateStart);
        }
        return this.suppliesDao.getSupReportsAllDev(this.printerDao.getDevList(), dateStart);
    }

    @GetMapping(value={"/get-dev-supplies"})
    public List<SuppliesGetSupDto> getDevicesSupplies(@RequestParam(required=false) Integer idDev, @RequestParam(required=false) Integer type, @RequestParam(required=false) String color, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateStart, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateEnd) {
        return this.suppliesService.getSup(idDev, type, color, dateStart, dateEnd);
    }

    @GetMapping(value={"/get-dev-units"})
    public List<SuppliesUnit> getDevices(@RequestParam Integer idDev) {
        return this.suppliesDao.getSupUnit(idDev.intValue());
    }

    @GetMapping(value={"/get-units-with-sup"})
    public List<SuppliesUnit> getUnitsWitsSup(@RequestParam Integer idDev, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateStart, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime dateEnd) {
        return this.suppliesService.getUnitsWitsSup(idDev, dateStart, dateEnd);
    }
}

