/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.dto.printer.SnmpCredentialDto;
import ru.interunity.ep.web.service.SnmpCredentialService;

@RestController
@RequestMapping(value={"/api/v2/snmp-credential"})
public class SnmpCredentialController {
    private final SnmpCredentialService snmpCredentialService;

    @GetMapping(value={"/get/{printerId}"})
    public ResponseEntity<SnmpCredentialDto> getSnmpCredential(@PathVariable long printerId) {
        return ResponseEntity.ok((Object)this.snmpCredentialService.getSnmpCredential(printerId));
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Void> saveSnmpCredential(@RequestBody SnmpCredentialDto snmpCredentialDto) {
        this.snmpCredentialService.saveSnmpCredential(snmpCredentialDto);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/delete/{printerId}"})
    public ResponseEntity<Void> deleteSnmpCredential(@PathVariable long printerId) {
        this.snmpCredentialService.deleteSnmpCredential(printerId);
        return ResponseEntity.ok().build();
    }

    public SnmpCredentialController(SnmpCredentialService snmpCredentialService) {
        this.snmpCredentialService = snmpCredentialService;
    }
}

