/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.web.widget.DashBoardComponents;
import ru.interunity.ep.web.widget.Widget;
import ru.interunity.ep.web.widget.WidgetData;
import ru.interunity.ep.web.widget.WidgetTemplate;
import ru.interunity.ep.web.widget.enums.Widgets;

@RestController
@RequestMapping(value={"/api/v2/dashboard"})
public class DashBoardWidgetController {
    private final WidgetTemplate template;
    private static final Logger log = LoggerFactory.getLogger(DashBoardWidgetController.class);

    public DashBoardWidgetController(WidgetTemplate template) {
        this.template = template;
    }

    @GetMapping(value={"/data/{widgetId}"})
    public ResponseEntity<WidgetData> getWidgetData(@PathVariable String widgetId) {
        WidgetData data = null;
        try {
            data = Widgets.valueOf((String)widgetId).getWidget().getData(this.template);
        }
        catch (IllegalArgumentException e) {
            log.error("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 id \u0432\u0438\u0434\u0436\u0435\u0442\u0430: " + widgetId);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        if (data != null) {
            data.setId(widgetId);
        }
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    @GetMapping(value={"/list"})
    public DashBoardComponents getWidgetList() {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (Widgets wdgt : Widgets.values()) {
            if (!wdgt.isActiv()) continue;
            widgets.add(Widget.builder().name(wdgt.getName()).id(wdgt.getId()).dataUrl(wdgt.getUrl()).widgetType(wdgt.getType()).build());
        }
        return DashBoardComponents.builder().widgets(widgets).build();
    }
}

