/*
 * Decompiled with CFR 0.152.
 */
package ru.interunity.ep.web.controller;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.interunity.ep.web.srv.JdbcSqlInit;

@RestController
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final JdbcSqlInit jdbcSqlInit;

    public ConfigController(JdbcSqlInit jdbcSqlInit) {
        this.jdbcSqlInit = jdbcSqlInit;
    }

    @PostMapping(value={"/PROP"})
    public String setProp(@RequestParam(required=false) String value, @RequestParam(required=false) String parameter) {
        if (value != null && parameter != null) {
            this.jdbcSqlInit.setParam(parameter, value);
        }
        return this.jdbcSqlInit.aGetProp();
    }

    @RequestMapping(value={"/PID"})
    public String setNet(@RequestParam(required=false) String action, @RequestParam(required=false) String ip_from, @RequestParam(required=false) String ip_to, @RequestParam(required=false) Integer idDiap) {
        if (action != null) {
            if (action.equals("get")) {
                return this.jdbcSqlInit.getListNetDiap();
            }
            if (action.equals("add") && this.checkDiap(ip_from, ip_to)) {
                this.jdbcSqlInit.addNetDiap(ip_from, ip_to);
            }
            if (action.equals("del")) {
                try {
                    this.jdbcSqlInit.delNetDiap(idDiap.intValue());
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
        return "200";
    }

    @RequestMapping(value={"/EP"})
    public String ipConfig(@RequestParam(required=false) String new_ip, @RequestParam(required=false) String new_mask, @RequestParam(required=false) String new_relay) {
        if (new_ip != null && new_mask != null && new_relay != null) {
            try {
                String toFile = "auto lo\niface lo inet loopback\nauto eth0\nallow-hotplug eth0\niface eth0 inet static\n\taddress " + new_ip + "\n\tnetmask " + new_mask + "\n\tgateway " + new_relay + "\nauto eth0:0\niface eth0:0  inet static\n\taddress 10.254.254.254\n\tnetmask 255.255.255.252\n";
                FileWriter fw = new FileWriter("/etc/network/interfaces", false);
                fw.write(toFile);
                fw.flush();
                fw.close();
                ProcessBuilder pb = new ProcessBuilder("/etc/init.d/networking", "restart");
                Process pr = pb.start();
                pr.waitFor();
                ProcessBuilder pbReb = new ProcessBuilder("/sbin/reboot");
                Process prReb = pbReb.start();
                prReb.waitFor();
                return "OK";
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return "FAIL";
            }
        }
        return this.getIPNM() + ";" + this.getGW();
    }

    private String getGW() {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("route", "-n");
            Process pr = pb.start();
            pr.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("UG")) continue;
                System.out.println(line.split(" ").length);
                return line.split(" ")[9] + line.split(" ")[12];
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return "192.168.1.2";
    }

    private String getIPNM() {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("/sbin/ifconfig", "eth0");
            Process pr = pb.start();
            pr.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("inet")) continue;
                return line.split(":")[1].split(" ")[0] + ";" + line.split(":")[3];
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return "192.168.1.158;255.255.255.0";
    }

    private boolean checkDiap(String ip_from, String ip_to) {
        log.info("from {} to {}", (Object)ip_from, (Object)ip_to);
        return true;
    }
}

