/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;

public class BooleanValue
extends MibValue {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private boolean value;

    private BooleanValue(boolean value) {
        super("BOOLEAN");
        this.value = value;
    }

    public MibValue initialize(MibLoaderLog log, MibType type) {
        return this;
    }

    public MibValue createReference() {
        return new BooleanValue(this.value);
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object toObject() {
        return new Boolean(this.value);
    }

    public String toString() {
        return this.value ? "TRUE" : "FALSE";
    }
}

