/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;

public abstract class MibValue
implements Comparable {
    private String name;
    private MibValueSymbol reference = null;

    protected MibValue(String name) {
        this.name = name;
    }

    public abstract MibValue initialize(MibLoaderLog var1, MibType var2) throws MibException;

    public MibValue createReference() throws UnsupportedOperationException {
        String msg = this.name + " value cannot be referenced";
        throw new UnsupportedOperationException(msg);
    }

    protected void clear() {
        this.reference = null;
    }

    public boolean isReferenceTo(String name) {
        if (this.reference == null) {
            return false;
        }
        if (this.reference.getName().equals(name)) {
            return true;
        }
        return this.reference.getValue().isReferenceTo(name);
    }

    public boolean isReferenceTo(String module, String name) {
        if (this.reference == null) {
            return false;
        }
        Mib mib = this.reference.getMib();
        if (mib.getName().equals(module) && this.reference.getName().equals(name)) {
            return true;
        }
        return this.reference.getValue().isReferenceTo(module, name);
    }

    public String getName() {
        return this.name;
    }

    public MibValueSymbol getReferenceSymbol() {
        return this.reference;
    }

    public void setReferenceSymbol(MibValueSymbol symbol) {
        this.reference = symbol;
    }

    public abstract Object toObject();
}

